/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import java.sql.Timestamp;
import java.util.ArrayList;

final class GTConnectionInfoDataSource
extends GTDataSource {
    private DatabaseConnection database;
    private ArrayList key_value_pairs;
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTConnectionInfoDataSource(DatabaseConnection connection) {
        super(connection.getSystem());
        this.database = connection;
        this.key_value_pairs = new ArrayList();
    }

    public GTConnectionInfoDataSource init() {
        this.key_value_pairs.add("auto_commit");
        this.key_value_pairs.add(this.database.getAutoCommit() ? "true" : "false");
        this.key_value_pairs.add("isolation_level");
        this.key_value_pairs.add(this.database.getTransactionIsolationAsString());
        this.key_value_pairs.add("user");
        this.key_value_pairs.add(this.database.getUser().getUserName());
        this.key_value_pairs.add("time_connection");
        this.key_value_pairs.add(new Timestamp(this.database.getUser().getTimeConnected()).toString());
        this.key_value_pairs.add("connection_string");
        this.key_value_pairs.add(this.database.getUser().getConnectionString());
        this.key_value_pairs.add("current_schema");
        this.key_value_pairs.add(this.database.getCurrentSchema());
        this.key_value_pairs.add("case_insensitive_identifiers");
        this.key_value_pairs.add(this.database.isInCaseInsensitiveMode() ? "true" : "false");
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.key_value_pairs.size() / 2;
    }

    public TObject getCellContents(int column, int row) {
        switch (column) {
            case 0: {
                return this.columnValue(column, (String)this.key_value_pairs.get(row * 2));
            }
            case 1: {
                return this.columnValue(column, (String)this.key_value_pairs.get(row * 2 + 1));
            }
        }
        throw new Error("Column out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.key_value_pairs = null;
        this.database = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRConnectionInfo"));
        def.addColumn(GTConnectionInfoDataSource.stringColumn("var"));
        def.addColumn(GTConnectionInfoDataSource.stringColumn("value"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

